//+------------------------------------------------------------------+
//| Magnified Market Price.mq4        ver1.4             by Habeeb   |
//+------------------------------------------------------------------+
//| Magnified Market Price_TRO_MODIFIED_VERSION                      |
//| MODIFIED BY AVERY T. HORTON, JR. AKA THERUMPLEDONE@GMAIL.COM     |
//| I am NOT the ORIGINAL author 
//  and I am not claiming authorship of this indicator. 
//  All I did was modify it. I hope you find my modifications useful.|
//|                                                                  |
//+------------------------------------------------------------------+
 

#property indicator_chart_window

 
 extern int    WhatCorner = 1;
 extern int    xAxis      = 20;
 extern int    yAxis      = 20;
 extern int    FontSize   = 20;

  extern string myNote     = "";
  extern color  myColor    = Yellow;
  extern int    myNoteSize = 20;

 
 extern bool    Extra_Decimal = true ;

  extern string note1          = "Change font colors automatically? True = Yes";
  extern bool   Bid_Ask_Colors = True;
  
  extern string note2       = "Default Font Color";
  extern color  FontColor   = Blue;
  extern color  FontColorUp = Lime;  
  extern color  FontColorDn = Red; 
  
  extern string note3    = "Font Size";
  
  
  extern string note4    = "Font Type";
  extern string FontType = "Lucida Console"; //"Comic Sans MS";
  
  extern string note5 = "Display the price in what corner?";
  extern string note6 = "Upper left=0; Upper right=1";
  extern string note7 = "Lower left=2; Lower right=3";
   
  
  
double        Old_Price;
double point ;
string symbol, tChartPeriod,  tShortName ;  
int    digits, period  ; 

 
string shortName ;
 
//+------------------------------------------------------------------+  
   
int init()
{
  
   period       =  Period() ;     
   tChartPeriod =  TimeFrameToString(period) ;  
   digits       =  Digits ;  
    
   if( !Extra_Decimal )
   { 
      if(digits == 5 || digits == 3) { digits = digits - 1 ; point = point * 10 ; }   
   }
    
   shortName = "MMP_TRO" ; 
 
 
           
return(0);
}
 
  
//+------------------------------------------------------------------+
int deinit()
  {
  ObjectDelete("Market_Price_Label"); 
  ObjectDelete("Market_Price_Note"); 
    
   
  return(0);
  }
//+------------------------------------------------------------------+
int start()
{
  
   if (Bid_Ask_Colors == True)
   {
    if (Bid > Old_Price) FontColor = FontColorUp;
    if (Bid < Old_Price) FontColor = FontColorDn;
    Old_Price = Bid;
   }
   
   string Market_Price = DoubleToStr(Bid, digits) + " " + Symbol() + " " + tChartPeriod;
  
   ObjectCreate("Market_Price_Label", OBJ_LABEL, 0, 0, 0);
   ObjectSetText("Market_Price_Label", Market_Price, FontSize, FontType, FontColor);
   ObjectSet("Market_Price_Label", OBJPROP_CORNER, WhatCorner);
   ObjectSet("Market_Price_Label", OBJPROP_XDISTANCE, xAxis );
   ObjectSet("Market_Price_Label", OBJPROP_YDISTANCE, yAxis );
   
   if( myNote != "")
   {
   ObjectCreate("Market_Price_Note", OBJ_LABEL, 0, 0, 0);
   ObjectSetText("Market_Price_Note", myNote, myNoteSize, FontType, myColor);
   ObjectSet("Market_Price_Note", OBJPROP_CORNER, WhatCorner);
   ObjectSet("Market_Price_Note", OBJPROP_XDISTANCE, xAxis );
   ObjectSet("Market_Price_Note", OBJPROP_YDISTANCE, 2*FontSize + yAxis );   
   
   }
  return(0);   
}
  
//+------------------------------------------------------------------+  

string TimeFrameToString(int tf)
{
   string tfs;
   switch(tf) {
      case PERIOD_M1:  tfs="M1"  ; break;
      case PERIOD_M5:  tfs="M5"  ; break;
      case PERIOD_M15: tfs="M15" ; break;
      case PERIOD_M30: tfs="M30" ; break;
      case PERIOD_H1:  tfs="H1"  ; break;
      case PERIOD_H4:  tfs="H4"  ; break;
      case PERIOD_D1:  tfs="D1"  ; break;
      case PERIOD_W1:  tfs="W1"  ; break;
      case PERIOD_MN1: tfs="MN";
   }
   return(tfs);
}
 
//+------------------------------------------------------------------+   